/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.FmtUI;
import com.quantumdata.fmteditor.editor.GateTrioPanel;
import com.quantumdata.fmteditor.editor.GateTrioSpec;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.fmteditor.fmtwidgets.FmtCheckBox;
import com.quantumdata.fmteditor.fmtwidgets.FmtComboBox;
import com.quantumdata.fmteditor.fmtwidgets.FmtNumericField;
import com.quantumdata.fmteditor.fmtwidgets.FmtRadioGroup;
import com.quantumdata.fmteditor.fmtwidgets.VideoKindComboBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FmtSyncPanel
extends QDPanel {
    private static final long serialVersionUID = 1L;
    private Format m_fmt;
    private FmtComboBox m_avcs;
    private static final double MMPERINCH = 25.4000508;

    public FmtSyncPanel(Format format) {
        this.m_fmt = format;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
        this.colorModelChanged();
    }

    private QDPanel createMainPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        QDPanel qDPanel2 = this.createUSizePanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 1;
        qDPanel2 = this.createPeldPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        qDPanel2 = this.createPanel1();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel2.setBorder(FmtUI.createLoweredBorder(10));
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 1;
        qDPanel2 = this.createPanel2();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel2.setBorder(FmtUI.createLoweredBorder(10));
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        qDPanel2 = this.createBottomPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        return qDPanel;
    }

    private QDPanel createUSizePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        JTextField jTextField = FmtUI.createLabel("Unit Size");
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        qDPanel.add((Component)jTextField);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jTextField = FmtUI.createLabel("Horizontal");
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        qDPanel.add((Component)jTextField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jTextField = FmtUI.createLabel("Vertical");
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        qDPanel.add((Component)jTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        FmtNumericField fmtNumericField = new FmtNumericField(this.m_fmt.getValue("HSIZ"));
        gridBagLayout.setConstraints(fmtNumericField, gridBagConstraints);
        qDPanel.add((Component)fmtNumericField);
        fmtNumericField.getValue().addListener(new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtSyncPanel.this.sizeChanged(cmdValue);
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.left = 15;
        fmtNumericField = new FmtNumericField(this.m_fmt.getValue("VSIZ"));
        gridBagLayout.setConstraints(fmtNumericField, gridBagConstraints);
        qDPanel.add((Component)fmtNumericField);
        fmtNumericField.getValue().addListener(new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtSyncPanel.this.sizeChanged(cmdValue);
            }
        });
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.left = 3;
        CmdValue cmdValue = this.m_fmt.getValue("USIZ");
        FmtRadioGroup fmtRadioGroup = new FmtRadioGroup(null, cmdValue, false, true);
        cmdValue.addListener(new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtSyncPanel.this.unitsChanged(cmdValue);
            }
        });
        gridBagLayout.setConstraints((Component)((Object)fmtRadioGroup), gridBagConstraints);
        qDPanel.add((Component)((Object)fmtRadioGroup));
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        return qDPanel;
    }

    private QDPanel createPeldPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        FmtUI.addTrio(0, 0, qDPanel, FmtUI.createLabel("Pixel Depth"), (JComponent)((Object)new FmtComboBox(this.m_fmt.getValue("PELD"))), (JComponent)FmtUI.createUnitLabel(""));
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        return qDPanel;
    }

    private QDPanel createBottomPanel() {
        QDPanel qDPanel = new QDPanel();
        GateTrioSpec gateTrioSpec = new GateTrioSpec();
        gateTrioSpec.title = "Analog Sync Gate";
        gateTrioSpec.gateLabel = new String[]{"R", "G", "B"};
        gateTrioSpec.gateFmtId = new String[]{"ASRG", "ASGG", "ASBG"};
        qDPanel.add((Component)((Object)new GateTrioPanel(this.m_fmt, gateTrioSpec)));
        gateTrioSpec = new GateTrioSpec();
        gateTrioSpec.title = "Digital Sync Gate";
        gateTrioSpec.gateLabel = new String[]{"H", "V", "C"};
        gateTrioSpec.gateFmtId = new String[]{"HSPG", "VSPG", "CSPG"};
        qDPanel.add((Component)((Object)new GateTrioPanel(this.m_fmt, gateTrioSpec)));
        gateTrioSpec = new GateTrioSpec();
        gateTrioSpec.title = "Digital Sync Polarity";
        gateTrioSpec.iconType = 1;
        gateTrioSpec.gateLabel = new String[]{"H", "V", "C"};
        gateTrioSpec.gateFmtId = new String[]{"HSPP", "VSPP", "CSPP"};
        qDPanel.add((Component)((Object)new GateTrioPanel(this.m_fmt, gateTrioSpec)));
        gateTrioSpec = new GateTrioSpec();
        gateTrioSpec.title = "Video Gate";
        gateTrioSpec.gateLabel = new String[]{"R", "G", "B"};
        gateTrioSpec.gateFmtId = new String[]{"REDG", "GRNG", "BLUG"};
        qDPanel.add((Component)((Object)new GateTrioPanel(this.m_fmt, gateTrioSpec)));
        return qDPanel;
    }

    private QDPanel createPanel1() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        int n = 0;
        JTextField jTextField = FmtUI.createLabel("Color Encoding");
        VideoKindComboBox videoKindComboBox = new VideoKindComboBox(this.m_fmt.getValue("AVST"), this.m_fmt.getValue("DVST"));
        ((JComboBox)((Object)videoKindComboBox)).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FmtSyncPanel.this.colorModelChanged();
            }
        });
        FmtUI.addPair(0, n++, qDPanel, jTextField, (JComponent)((Object)videoKindComboBox));
        ((JComponent)((Object)videoKindComboBox)).setToolTipText("Set AVST and DVST");
        jTextField = FmtUI.createLabel("Sync Type");
        FmtUI.addPair(0, n++, qDPanel, jTextField, (JComponent)((Object)new FmtComboBox(this.m_fmt.getValue("SSST"))));
        jTextField = FmtUI.createLabel("ACS Type");
        FmtUI.addPair(0, n++, qDPanel, jTextField, (JComponent)((Object)new FmtComboBox(this.m_fmt.getValue("ASCT"))));
        jTextField = FmtUI.createLabel("DCS Type");
        FmtUI.addPair(0, n++, qDPanel, jTextField, (JComponent)((Object)new FmtComboBox(this.m_fmt.getValue("DSCT"))));
        jTextField = FmtUI.createLabel("DSS Type");
        FmtUI.addPair(0, n++, qDPanel, jTextField, (JComponent)((Object)new FmtComboBox(this.m_fmt.getValue("DSST"))));
        jTextField = FmtUI.createLabel("SubCarrier");
        this.m_avcs = new FmtComboBox(this.m_fmt.getValue("AVCS"));
        FmtUI.addPair(0, n++, qDPanel, jTextField, (JComponent)((Object)this.m_avcs));
        return qDPanel;
    }

    private QDPanel createPanel2() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        int n = 0;
        JTextField jTextField = FmtUI.createLabel("Analog Video Swing");
        QDLabel qDLabel = FmtUI.createUnitLabel("volts white minus blank");
        FmtNumericField fmtNumericField = new FmtNumericField(this.m_fmt.getValue("AVSS"));
        FmtUI.addTrio(0, n++, qDPanel, jTextField, fmtNumericField, (JComponent)qDLabel);
        jTextField = FmtUI.createLabel("Analog Sync Swing");
        qDLabel = FmtUI.createUnitLabel("volts blank minus sync");
        fmtNumericField = new FmtNumericField(this.m_fmt.getValue("ASSS"));
        FmtUI.addTrio(0, n++, qDPanel, jTextField, fmtNumericField, (JComponent)qDLabel);
        fmtNumericField = new FmtNumericField(this.m_fmt.getValue("GAMA"), 0.0, 9999.0);
        FmtCheckBox fmtCheckBox = new FmtCheckBox(this.m_fmt.getValue("GAMC"), "Gamma", fmtNumericField);
        fmtCheckBox.setHorizontalTextPosition(2);
        qDLabel = FmtUI.createUnitLabel(" ");
        FmtUI.addTrio(0, n++, qDPanel, (JComponent)((Object)fmtCheckBox), fmtNumericField, (JComponent)qDLabel);
        fmtNumericField = new FmtNumericField(this.m_fmt.getValue("AVPS"), 0.0, 9999.0);
        fmtCheckBox = new FmtCheckBox(this.m_fmt.getValue("AVPG"), "Pedestal", fmtNumericField);
        fmtCheckBox.setHorizontalTextPosition(2);
        qDLabel = FmtUI.createUnitLabel("IRE");
        FmtUI.addTrio(0, n++, qDPanel, (JComponent)((Object)fmtCheckBox), fmtNumericField, (JComponent)qDLabel);
        jTextField = FmtUI.createLabel("Analog Cal. Mode");
        FmtComboBox fmtComboBox = new FmtComboBox(this.m_fmt.getValue("AVCM"));
        FmtUI.addTrio(0, n++, qDPanel, jTextField, (JComponent)((Object)fmtComboBox), null);
        jTextField = FmtUI.createLabel("Analog Color Order");
        FmtUI.addTrio(0, n++, qDPanel, jTextField, (JComponent)((Object)new FmtComboBox(this.m_fmt.getValue("AVCO"))), null);
        return qDPanel;
    }

    private void colorModelChanged() {
        if (this.m_fmt.getValue("AVST").getInt() != 4) {
            this.m_avcs.setSelectedIndex(0);
            this.m_avcs.setEnabled(false);
        } else {
            this.m_avcs.setEnabled(true);
        }
    }

    private void unitsChanged(CmdValue cmdValue) {
        CmdValue cmdValue2 = this.m_fmt.getValue("HSIZ");
        CmdValue cmdValue3 = this.m_fmt.getValue("VSIZ");
        double d = cmdValue2.getDouble();
        double d2 = cmdValue3.getDouble();
        if (cmdValue.getInt() == 1) {
            d /= 25.4000508;
            d2 /= 25.4000508;
        } else {
            d *= 25.4000508;
            d2 *= 25.4000508;
        }
        cmdValue2.setDouble(d);
        cmdValue3.setDouble(d2);
    }

    private void sizeChanged(CmdValue cmdValue) {
        if (cmdValue.getDouble() <= 1.0E-5) {
            cmdValue.setDouble(1.0);
        }
    }
}

